/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatInfo;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.CK_TOKEN_INFO;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;

public class ListerAlgo {
    private static Logger log = Logger.getLogger(ListerAlgo.class);

    public static Resultat traitementP11(PKCS11 pKCS11, long l) throws ExceptionTraitement {
        try {
            if (pKCS11 != null) {
                ResultatInfo resultatInfo;
                block12: {
                    Object object;
                    resultatInfo = new ResultatInfo("Obtenir la liste des algorithmes support\u00e9s par la carte ");
                    LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                    resultatInfo.setInfos(linkedHashMap);
                    try {
                        object = pKCS11.C_GetTokenInfo(l);
                        if (object != null) {
                            resultatInfo.appendTraitement(new String(object.label).trim() + " (C_GetMechanismList)");
                        } else {
                            resultatInfo.appendTraitement("(C_GetMechanismList)");
                        }
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        // empty catch block
                    }
                    try {
                        object = pKCS11.C_GetMechanismList(l);
                        if (object != null) {
                            linkedHashMap.put("Nombre d'algorithmes support\u00e9s:", Integer.toString(((CK_TOKEN_INFO)object).length));
                            for (int i = 0; i < ((CK_TOKEN_INFO)object).length; ++i) {
                                CK_TOKEN_INFO cK_TOKEN_INFO = object[i];
                                resultatInfo.getObjets().add((long)cK_TOKEN_INFO);
                                linkedHashMap.put("Algorithme " + (i + 1), TraitementsUtil.getNomAlgo((long)cK_TOKEN_INFO));
                            }
                            break block12;
                        }
                        log.error((Object)"La liste des algorithmes retournee est nulle");
                        throw new ExceptionTraitement(9, "La liste des algorithmes retourn\u00e9e est nulle");
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                        resultatInfo.setCodeRetour(pKCS11Exception.getErrorCode());
                    }
                }
                return resultatInfo;
            }
            log.error((Object)"La librairie est nulle");
            throw new ExceptionTraitement(9, "La librairie est nulle");
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExceptionTraitement) {
                throw (ExceptionTraitement)throwable;
            }
            log.error((Object)("Une erreur inattendue est survenue : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            throw new ExceptionTraitement(9, "Une erreur inattendue est survenue");
        }
    }
}

